<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class Prodotto {
        private $db;
        private $id;
        private $codiceProdotto;
        private $idFornitore;
        private $lingua;
        private $prodottoRiferimento;
        private $prodottoPadre;
        private $ean;
        private $nome;
        private $alias;
        private $immagine;
        private $template;
        private $pubblicato;
        private $usaVariazioni;
        private $categoria;
        private $prodottoInesauribile;
        private $disponibilita;
        private $prezzo;
        private $prezzoOfferta;
        private $iva;
        private $prezzoAcquisto;
        private $prezzoUnitario;
        private $unita;
        private $minimoAcquisto;
        private $metaDescrizione;
        private $descrizione;
        private $testoDettagli;
        private $marca;
        private $modello;
        private $formato;
        private $materiale;
        private $capacita;
        private $colore;
        private $larghezza;
        private $altezza;
        private $profondita;
        private $peso;
        private $pesoVolumetrico;
        private $tipoProdotto;
        private $numeroVisite;
        private $numeroVendite;
        private $abilitaCommenti;
        private $dataInserimento;
        private $datiProdotto;
        
        function __construct($db, $id) {
            $this->db = $db;
            $this->id = $id;
        }

        function crea() {
            $query = "INSERT INTO `geecEc_prodotti` (`id`, `codiceProdotto`, `idFornitore`, `lingua`, `prodottoRiferimento`, `prodottoPadre`, `ean`, `nome`, `alias`, `immagine`, `template`, `pubblicato`, `usaVariazioni`, `categoria`, `disponibilita`, `prodottoInesauribile`, `prezzo`, `prezzoOfferta`, `iva`, `prezzoAcquisto`, `prezzoUnitario`, `unita`, `minimoAcquisto`, `metaDescrizione`, `descrizione`, `testoDettagli`, `marca`, `modello`, `formato`, `materiale`, `capacità`, `colore`, `larghezza`, `altezza`, `profondità`, `peso`, `pesoVolumetrico`, `tipoProdotto`, `numeroVisite`, `numeroVendite`, `abilitaCommenti`, `dataInserimento`) 
                        VALUES (NULL, '$this->codiceProdotto', '$this->idFornitore', '$this->lingua', '$this->prodottoRiferimento', '$this->prodottoPadre', '$this->ean', '$this->nome', '$this->alias', '$this->immagine', '$this->template', '$this->pubblicato', '$this->usaVariazioni', '$this->categoria', '$this->disponibilita', '$this->prodottoInesauribile', '$this->prezzo', '$this->prezzoOfferta', '$this->iva', '$this->prezzoAcquisto', '$this->prezzoUnitario', '$this->unita', '$this->minimoAcquisto', '$this->metaDescrizione', '$this->descrizione', '$this->testoDettagli', '$this->marca', '$this->modello', '$this->formato', '$this->materiale', '$this->capacita', '$this->colore', '$this->larghezza', '$this->altezza', '$this->profondita', '$this->peso', '$this->pesoVolumetrico', '$this->tipoProdotto', '$this->numeroVisite', '$this->numeroVendite', '$this->abilitaCommenti', '$this->dataInserimento')";
            return $this->db->eseguiQueryCreazione($query);
        }
        
        function salvaModifiche() {
            if($this->alias=="") {
                $this->alias = generaAlias($this->db,$this->nome,"geecEc_prodotti","nome");
            }
            
            $query = "UPDATE geecEc_prodotti SET codiceProdotto='$this->codiceProdotto', idFornitore='$this->idFornitore', prodottoRiferimento='$this->prodottoRiferimento', prodottoPadre='$this->prodottoPadre', ean='$this->ean', nome='$this->nome', alias='$this->alias', metaDescrizione='$this->metaDescrizione', descrizione='$this->descrizione', template='$this->template', pubblicato='$this->pubblicato', categoria='$this->categoria', disponibilita='$this->disponibilita', prodottoInesauribile='$this->prodottoInesauribile', prezzo='$this->prezzo', prezzoOfferta='$this->prezzoOfferta', iva='$this->iva', prezzoAcquisto='$this->prezzoAcquisto', prezzoUnitario='$this->prezzoUnitario', unita='$this->unita', minimoAcquisto='$this->minimoAcquisto', testoDettagli='$this->testoDettagli', marca='$this->marca', modello='$this->modello', formato='$this->formato', materiale='$this->materiale', colore='$this->colore', larghezza='$this->larghezza', altezza='$this->altezza', profondità='$this->profondita', capacità='$this->capacita', peso='$this->peso', pesoVolumetrico='$this->pesoVolumetrico', tipoProdotto='$this->tipoProdotto' WHERE id=$this->id";
            $this->db->eseguiQueryLettura($query);
        }
        
        function modificaFoto($percorsoFoto) {
            $query = "UPDATE geecEc_prodotti SET immagine='$percorsoFoto' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geecEc_prodotti",$this->id);
            
            // elimino gli attributi associati al prodotto
            $query = "DELETE FROM geecEc_attributiProdotto WHERE idProdotto=$this->id";
            $this->db->eseguiQueryScrittura($query);
            
            // elimino le variazioni associate al prodotto
            $query = "DELETE FROM geecEc_variazioniProdotto WHERE idProdotto=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function duplica($prefisso = "Copia di", $lingua="") {
            $contenutoDaCopiare = $this->db->leggiSingolaRiga("geecEc_prodotti",$this->id);
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geecEc_prodotti WHERE id={$this->id}");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geecEc_prodotti SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            $this->db->eseguiQueryScrittura("DROP TABLE tabella_temporanea");
            
            // se la lingua non è stata specificata va messo il valore del contenuto da copiare
            if($lingua=="") {
                $lingua = $contenutoDaCopiare["lingua"];
            }
            
            // aggiorno titolo, alias, numero visite e altri campi che vanno aggiornati, c'è una differenza da fare se si sta duplicando un
            // elemento del portfolio o qualcos'altro, se è un elemento del protfolio contenutoRiferimento non va portato a 0 
            $nuovoAlias = generaAlias($this->db,$contenutoDaCopiare["nome"],"geecEc_prodotti","nome");
            $nomeEscape = filter_var($contenutoDaCopiare["nome"],FILTER_SANITIZE_ADD_SLASHES);
            $this->db->eseguiQueryScrittura("UPDATE geecEc_prodotti SET nome='$prefisso $nomeEscape', alias='$nuovoAlias', lingua='$lingua', numeroVisite = 0, dataInserimento='".date("Y-m-d")."' WHERE id=$idContenutoDuplicato");
            
            // duplico i componenti
            $query = "SELECT cp.*, c.tipo, c.tabellaRiferimento FROM geecB_composizionePagine AS cp JOIN geecB_componenti AS c ON cp.idComponente = c.id WHERE cp.idPagina={$this->id} AND tipo LIKE 'prodotto' ORDER BY posizione ASC";
            $result = $this->db->eseguiQueryLettura($query);
            while($componente = $result->fetch_array()) {
                $this->duplicaComponente($componente["id"], $idContenutoDuplicato);
            }
            
            // duplico gli attributi
            $query = "SELECT * FROM geecEc_attributiProdotto WHERE idProdotto=$this->id";
            $resultAttributi = $this->db->eseguiQueryLettura($query);
            while($attributo = $resultAttributi->fetch_array()) {
                $nomeEscape   = filter_var($attributo["nome"],FILTER_SANITIZE_ADD_SLASHES);
                $valoriEscape = filter_var($attributo["valori"],FILTER_SANITIZE_ADD_SLASHES);
                $this->db->eseguiQueryScrittura("INSERT INTO `geecEc_attributiProdotto` (`id`, `idProdotto`, `nome`, `valori`, `costi`) VALUES (NULL, '$idContenutoDuplicato', '$nomeEscape', '$valoriEscape', '{$attributo["costi"]}');");
            }
            
            // duplico le variazioni
            $query = "SELECT * FROM geecEc_variazioniProdotto WHERE idProdotto=$this->id";
            $resultVariazioni = $this->db->eseguiQueryLettura($query);
            while($variazione = $resultVariazioni->fetch_array()) {
                $nomeEscape   = filter_var($variazione["nome"],FILTER_SANITIZE_ADD_SLASHES);
                $codiceProdotto = ($variazione["codiceProdotto"]!="") ? "Copia di {$variazione["codiceProdotto"]}" : "";
                $this->db->eseguiQueryScrittura("INSERT INTO `geecEc_variazioniProdotto` (`id`, `codiceProdotto`, `idProdotto`, `nome`, `costo`, `quantita`) VALUES (NULL, '$codiceProdotto', '$idContenutoDuplicato', '$nomeEscape', '{$variazione["costo"]}', '{$variazione["quantita"]}'); ");
            }            
            return $idContenutoDuplicato;
        }
        
        function traduci($lingua) {
            $idContenutoTradotto = $this->duplica("Traduzione in $lingua di",$lingua);
            $this->db->eseguiQueryScrittura("UPDATE geecEc_prodotti SET prodottoRiferimento='$this->id' WHERE id=$idContenutoTradotto");
            return $idContenutoTradotto;
        }
        
        function duplicaComponente($idComponente,$idContenuto=0) {
            $queryUtimaSezione  = "SELECT * FROM geecB_composizionePagine ORDER BY id DESC";
            $risSezione         = $this->db->eseguiQueryLettura($queryUtimaSezione);
            $ultimaSezione      = $risSezione->fetch_assoc();
            $progressivoSezione = $ultimaSezione["id"] +1;
            $idSezione  = "sezione$progressivoSezione";
            
            /*
             * Il campo opzionale $idContenuto ha valore diverso da 0 solo quando viene effettuata una duplicazione, in tal caso
             * bisogna considerare le tabelle del contenuto duplicato e non di quell obase
             */
            $idContenutoElementoDuplicato = ($idContenuto!=0) ? $idContenuto : $this->id;
                    
            $query    = "SELECT cp.*, c.nome AS nomeComponente, c.tipo, c.tabellaRiferimento FROM geecB_composizionePagine AS cp JOIN geecB_componenti AS c ON cp.idComponente = c.id WHERE cp.id={$idComponente}";
            $risQuery = $this->db->eseguiQueryLettura($query);
            $componente = $risQuery->fetch_assoc();
            
            $testo          = filter_var($componente["testo"],FILTER_SANITIZE_ADD_SLASHES);
            $codiceGenerato = filter_var($componente["codiceGenerato"],FILTER_SANITIZE_ADD_SLASHES);
            $script         = filter_var($componente["script"],FILTER_SANITIZE_ADD_SLASHES);
            
            if($componente["tipo"]=="componenteDinamicoPagine" || $componente["tipo"]=="componenteStrutturaPagina") {
                $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporaneaComponente SELECT * FROM {$componente["tabellaRiferimento"]} WHERE id={$componente["idElemento"]}");
                $this->db->eseguiQueryScrittura("UPDATE tabella_temporaneaComponente SET id = 0;");
                $this->db->eseguiQueryScrittura("INSERT INTO {$componente["tabellaRiferimento"]} SELECT * FROM tabella_temporaneaComponente;");
                $idElemento = $this->db->idUltimoElemento();
                $this->db->eseguiQueryScrittura("DROP TABLE tabella_temporaneaComponente");
                $this->duplicaElementiComponente($componente,$idElemento,$idContenuto);
                
                $queryAggiornamentoNomeComponente = "UPDATE {$componente["tabellaRiferimento"]} SET nome = CONCAT('Copia di',' ',nome) WHERE id=$idElemento";
                $this->db->eseguiQueryCreazione($queryAggiornamentoNomeComponente);
                
                $queryInserimentoComponente = "INSERT INTO geecB_composizionePagine VALUES(NULL,{$componente["idComponente"]},$idContenutoElementoDuplicato,'{$componente["tipoElemento"]}',{$idElemento},{$componente["posizione"]},'$testo','$codiceGenerato','$script','$idSezione','{$componente["classeSezione"]}','{$componente["aTuttaLarghezza"]}','{$componente["margineSezione"]}','{$componente["paddingSezione"]}','{$componente["animazione"]}','{$componente["coloreSfondo"]}','{$componente["immagineSfondo"]}','{$componente["videoSfondo"]}','{$componente["altreOpzioni"]}')";
            }
            else if($componente["nomeComponente"]=="Singola risorsa") {
                $fileScaricabile    = new FileScaricabile($this->getDb(), $componente["idElemento"]);
                $idRisorsaDuplicata = $fileScaricabile->duplica();
                $altreOpzioni = filter_var(str_replace("nomeRisorsa=","nomeRisorsa=Copia di ",$componente["altreOpzioni"]),FILTER_SANITIZE_ADD_SLASHES);
                $queryInserimentoComponente = "INSERT INTO geecB_composizionePagine VALUES(NULL,{$componente["idComponente"]},$idContenutoElementoDuplicato,'{$componente["tipoElemento"]}','{$idRisorsaDuplicata}',{$componente["posizione"]},'$testo','$codiceGenerato','$script','{$idSezione}','{$componente["classeSezione"]}','{$componente["aTuttaLarghezza"]}','{$componente["margineSezione"]}','{$componente["paddingSezione"]}','{$componente["animazione"]}','{$componente["coloreSfondo"]}','{$componente["immagineSfondo"]}','{$componente["videoSfondo"]}','$altreOpzioni')";
            }
            else {
                $queryInserimentoComponente = "INSERT INTO geecB_composizionePagine VALUES(NULL,{$componente["idComponente"]},$idContenutoElementoDuplicato,'{$componente["tipoElemento"]}',{$componente["idElemento"]},{$componente["posizione"]},'$testo','$codiceGenerato','$script','{$idSezione}','{$componente["classeSezione"]}','{$componente["aTuttaLarghezza"]}','{$componente["margineSezione"]}','{$componente["paddingSezione"]}','{$componente["animazione"]}','{$componente["coloreSfondo"]}','{$componente["immagineSfondo"]}','{$componente["videoSfondo"]}','{$componente["altreOpzioni"]}')";
            }
            $idNuovoComponente = $this->db->eseguiQueryCreazione($queryInserimentoComponente);
            
            $posizioneNuovoComponente = $componente["posizione"] +1;
            $this->modificaPosizioneComponente($idNuovoComponente,$posizioneNuovoComponente,$idContenuto);
            return $idNuovoComponente;
        }
        
        function modificaPosizioneComponente($idComponente,$posizione,$idContenuto=0) {
            $tipoElemento  = "prodotto";
            
            /*
             * Il campo opzionale $idContenuto ha valore diverso da 0 solo quando viene effettuata una duplicazione, in tal caso
             * bisogna considerare le tabelle del contenuto duplicato e non di quell obase
             */
            $idContenutoDaCercare = ($idContenuto!=0) ? $idContenuto : $this->id;
            
            // le occorrenze di geecB_composizionePagine prese in considerazione sono solo quelle di tipo contenuto (devono essere escluse quelle delle sezioni multiple)
            $queryPosizione = "SELECT * FROM geecB_composizionePagine WHERE idPagina=$idContenutoDaCercare AND tipoElemento LIKE '$tipoElemento' AND id != $idComponente ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geecB_composizionePagine SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geecB_composizionePagine SET posizione=$posizione WHERE id = $idComponente ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function modificaOpzioniSezioneComponente($id,$idSezione,$classeSezione,$aTuttaLarghezza,$margineSezione,$paddingSezione,$coloreSfondo,$percorsoImmagine,$percorsoFileVideo) {
            $queryModifica = "UPDATE geecB_composizionePagine SET idSezione='$idSezione', classeSezione='$classeSezione', aTuttaLarghezza='$aTuttaLarghezza', margineSezione='$margineSezione', paddingSezione='$paddingSezione', coloreSfondo='$coloreSfondo' WHERE id=$id";
            $this->db->eseguiQueryLettura($queryModifica);
            
            if($percorsoImmagine!="") {
                $queryModifica = "UPDATE geecB_composizionePagine SET immagineSfondo='$percorsoImmagine' WHERE id=$id";
                $this->db->eseguiQueryLettura($queryModifica);
            }
            
            if($percorsoFileVideo!="") {
                $queryModifica = "UPDATE geecB_composizionePagine SET videoSfondo='$percorsoFileVideo' WHERE id=$id";
                $this->db->eseguiQueryLettura($queryModifica);
            }
        }
        
        /*
         * Questo metodo serve per duplicare gli elementi all'interno del componente, esempio gli elementi di un form,
         * le slide di uno slider e cosi via.
         * 
         * Usato anche per le sezioni multiple (due, tre e quattro colonne) dove va a ricreare i componenti ad essa collegata
         * 
         * @param $componente: dati del componente di partenza
         * @param $idElemento: id dell'occorrenza creata
         * 
         * Il campo opzionale $idContenuto ha valore diverso da 0 solo quando viene effettuata una duplicazione, in tal caso
         * bisogna considerare le tabelle del contenuto duplicato e non il campo $this-id
         */
        function duplicaElementiComponente($componente,$idElemento,$idContenuto=0) {
            if($componente["nomeComponente"]=="Sezione a due colonne") {
                $datiSezioneADueColonne = $this->db->leggiSingolaRiga("geec_sezioniADueColonne",$componente["idElemento"]);
                $idComponente1 = ($datiSezioneADueColonne["idComponenteSezione1"]!=0) ? $this->duplicaComponente($datiSezioneADueColonne["idComponenteSezione1"],$idContenuto) : 0;
                $idComponente2 = ($datiSezioneADueColonne["idComponenteSezione2"]!=0) ? $this->duplicaComponente($datiSezioneADueColonne["idComponenteSezione2"],$idContenuto) : 0;
                
                $queryAggiornamentoSezione = "UPDATE geec_sezioniADueColonne SET idComponenteSezione1=$idComponente1, idComponenteSezione2=$idComponente2 WHERE id=$idElemento";
                $this->db->eseguiQueryScrittura($queryAggiornamentoSezione);
            }
            else if($componente["nomeComponente"]=="Sezione a tre colonne") {
                $datiSezioneATreColonne = $this->db->leggiSingolaRiga("geec_sezioniATreColonne",$componente["idElemento"]);
                $idComponente1 = ($datiSezioneATreColonne["idComponenteSezione1"]!=0) ? $this->duplicaComponente($datiSezioneATreColonne["idComponenteSezione1"],$idContenuto) : 0;
                $idComponente2 = ($datiSezioneATreColonne["idComponenteSezione2"]!=0) ? $this->duplicaComponente($datiSezioneATreColonne["idComponenteSezione2"],$idContenuto) : 0;
                $idComponente3 = ($datiSezioneATreColonne["idComponenteSezione3"]!=0) ? $this->duplicaComponente($datiSezioneATreColonne["idComponenteSezione3"],$idContenuto) : 0;
                                
                $queryAggiornamentoSezione = "UPDATE geec_sezioniATreColonne SET idComponenteSezione1=$idComponente1, idComponenteSezione2=$idComponente2, idComponenteSezione3=$idComponente3 WHERE id=$idElemento";
                $this->db->eseguiQueryScrittura($queryAggiornamentoSezione);
            }
            else if($componente["nomeComponente"]=="Sezione a quattro colonne") {
                $datiSezioneAQuattroColonne = $this->db->leggiSingolaRiga("geec_sezioniAQuattroColonne",$componente["idElemento"]);
                $idComponente1 = ($datiSezioneAQuattroColonne["idComponenteSezione1"]!=0) ? $this->duplicaComponente($datiSezioneAQuattroColonne["idComponenteSezione1"],$idContenuto) : 0;
                $idComponente2 = ($datiSezioneAQuattroColonne["idComponenteSezione2"]!=0) ? $this->duplicaComponente($datiSezioneAQuattroColonne["idComponenteSezione2"],$idContenuto) : 0;
                $idComponente3 = ($datiSezioneAQuattroColonne["idComponenteSezione3"]!=0) ? $this->duplicaComponente($datiSezioneAQuattroColonne["idComponenteSezione3"],$idContenuto) : 0;
                $idComponente4 = ($datiSezioneAQuattroColonne["idComponenteSezione4"]!=0) ? $this->duplicaComponente($datiSezioneAQuattroColonne["idComponenteSezione4"],$idContenuto) : 0;
                
                $queryAggiornamentoSezione = "UPDATE geec_sezioniAQuattroColonne SET idComponenteSezione1=$idComponente1, idComponenteSezione2=$idComponente2, idComponenteSezione3=$idComponente3, idComponenteSezione4=$idComponente4 WHERE id=$idElemento";
                $this->db->eseguiQueryScrittura($queryAggiornamentoSezione);
            }
            else if($componente["nomeComponente"]=="Portfolio") {
                $query       = "SELECT * FROM geecB_contenuti WHERE contenutoRiferimento='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geecB_contenuti",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geecB_contenuti SET alias='copia-di-{$elementoDaCopiare["alias"]}', contenutoRiferimento=$idElemento, numeroVisite=0 WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Slider") {
                $query       = "SELECT * FROM geec_slide WHERE idSlider='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_slide",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_slide SET idSlider=$idElemento, numeroClick=0 WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Griglia contenuti") {
                $query       = "SELECT * FROM geec_immaginiGriglia WHERE idGriglia='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_immaginiGriglia",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_immaginiGriglia SET idGriglia=$idElemento WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Form") {
                $query       = "SELECT * FROM geec_elementiForm WHERE idForm='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_elementiForm",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_elementiForm SET idForm=$idElemento WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Lista") {
                $query       = "SELECT * FROM geec_elementiLista WHERE idLista='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_elementiLista",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_elementiLista SET idLista=$idElemento WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Contatore") {
                $query       = "SELECT * FROM geec_elementiContatore WHERE idContatore='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_elementiContatore",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_elementiContatore SET idContatore=$idElemento WHERE id=$idContenutoDuplicato");
                }
            }
        }
        
        function copiaTabellaElemento($tabella,$id) {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM $tabella WHERE id=$id");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO $tabella SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            $this->db->eseguiQueryScrittura("DROP TABLE tabella_temporanea");
            
            return $idContenutoDuplicato;
        }
        
        function caricaDatiDalDatabase(){
            $datiProdotto = $this->db->leggiSingolaRiga("geecEc_prodotti",$this->id);
            $this->codiceProdotto       = $datiProdotto["codiceProdotto"];
            $this->idFornitore          = $datiProdotto["idFornitore"];
            $this->lingua               = $datiProdotto["lingua"];
            $this->prodottoRiferimento  = $datiProdotto["prodottoRiferimento"];
            $this->prodottoPadre        = $datiProdotto["prodottoPadre"];
            $this->ean                  = $datiProdotto["ean"];
            $this->nome                 = $datiProdotto["nome"];
            $this->alias                = $datiProdotto["alias"];
            $this->lingua               = $datiProdotto["lingua"];
            $this->immagine             = $datiProdotto["immagine"];
            $this->template             = $datiProdotto["template"];
            $this->pubblicato           = $datiProdotto["pubblicato"];
            $this->usaVariazioni        = $datiProdotto["usaVariazioni"];
            $this->categoria            = $datiProdotto["categoria"];
            $this->prodottoInesauribile = $datiProdotto["prodottoInesauribile"];
            $this->disponibilita   = $datiProdotto["disponibilita"];
            $this->prezzoAcquisto  = $datiProdotto["prezzoAcquisto"];
            $this->prezzo          = $datiProdotto["prezzo"];
            $this->prezzoOfferta   = $datiProdotto["prezzoOfferta"];
            $this->iva             = $datiProdotto["iva"];
            $this->prezzoUnitario  = $datiProdotto["prezzoUnitario"];
            $this->unita           = $datiProdotto["unita"];
            $this->minimoAcquisto  = $datiProdotto["minimoAcquisto"];
            $this->metaDescrizione = $datiProdotto["metaDescrizione"];
            $this->descrizione     = $datiProdotto["descrizione"];
            $this->testoDettagli   = $datiProdotto["testoDettagli"];
            $this->marca           = $datiProdotto["marca"];
            $this->modello         = $datiProdotto["modello"];
            $this->formato         = $datiProdotto["formato"];
            $this->materiale       = $datiProdotto["materiale"];
            $this->colore          = $datiProdotto["colore"];
            $this->larghezza       = $datiProdotto["larghezza"];
            $this->altezza         = $datiProdotto["altezza"];
            $this->profondita      = $datiProdotto["profondità"];
            $this->peso            = $datiProdotto["peso"];
            $this->pesoVolumetrico = $datiProdotto["pesoVolumetrico"];
            $this->capacita        = $datiProdotto["capacità"];
            $this->tipoProdotto    = $datiProdotto["tipoProdotto"];
            $this->datiProdotto    = $datiProdotto;
        }
        
        function eliminaImmagine($id) {
            $this->db->eseguiQueryCancellazione("geec_immagini",$id);
        }

        function modificaPosizioneImmagine($idImmagine,$nuovaPosizione){
            $queryImmagini       = "SELECT * FROM geec_immagini WHERE idContenuto = $this->id AND id != $idImmagine ORDER BY posizione ASC";
            $risImmaginiProdotto = $this->db->eseguiQueryLettura($queryImmagini);
            
            $posizione = 1;
            while($immagine = $risImmaginiProdotto->fetch_assoc()) {
                if($posizione==$nuovaPosizione) {
                    $posizione++;
                }
                $queryAggiornamentoPosizione = "UPDATE geec_immagini SET posizione=$posizione WHERE id={$immagine["id"]}";
                $this->db->eseguiQueryScrittura($queryAggiornamentoPosizione);
                //echo $queryAggiornamentoPosizione."<br>\n";
                $posizione++;
            }
            
            // infine aggiorno l'immagine che è stat arichiesta di aggiornare
            $queryAggiornamentoPosizione = "UPDATE geec_immagini SET posizione=$nuovaPosizione WHERE id=$idImmagine";
            $this->db->eseguiQueryScrittura($queryAggiornamentoPosizione);
        }
        
        function aggiungiAttributo($nome,$valori,$costi) {
            $query = "INSERT INTO `geecEc_attributiProdotto` (`id`, `idProdotto`, `nome`, `valori`, `costi`) 
                        VALUES (NULL, '$this->id', '$nome', '$valori', '$costi'); ";
            $this->db->eseguiQueryLettura($query);
        }
        
        function modificaAttributo($id,$nome,$valori,$costi) {
            $query = "UPDATE geecEc_attributiProdotto SET nome = '$nome', valori='$valori', costi = '$costi' WHERE id = $id";
            $this->db->eseguiQueryLettura($query);
        }
        
        function aggiornaUsaVariazioni($usaVariazioni) {
            $query = "UPDATE geecEc_prodotti SET usaVariazioni = '$usaVariazioni' WHERE id = $this->id";
            $this->db->eseguiQueryLettura($query);
        }
        
        function eliminaAttributo($id) {
            $this->db->eseguiQueryCancellazione("geecEc_attributiProdotto",$id);
        }
        
        /*
         * Crea tutte le variazioni del prodotto. Recupera tutti gli attributi e genera 
         * tutte le possibili variazioni
         */
        function creaTutteLeVariazioni() {
            $query = "SELECT * FROM geecEc_attributiProdotto WHERE idProdotto=$this->id";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            if($risultatoQuery->num_rows==1) { // se c'è un solo attributo viene invocato il metodo crea variazioni
                $attributo = $risultatoQuery->fetch_assoc();
                $this->creaVariazioni($attributo["id"]);
            }
            else { // altrimenti recupera un attributo da utilizzare come base e poi unisce con gli altri che trovano
                $datiPrimoAttributo = $risultatoQuery->fetch_assoc();
                $arrayValoriPrimoAttributo = explode(",",$datiPrimoAttributo["valori"]);

                while($attributo = $risultatoQuery->fetch_assoc()) {
                    $arrayValori   = explode(",",$attributo["valori"]);
                    $arrayCosti    = explode(",",$attributo["costi"]);

                    $i = 0;
                    foreach($arrayValori as $valore) {
                        foreach($arrayValoriPrimoAttributo as $valorePrimoAttributo) {
                            $query = "INSERT INTO geecEc_variazioniProdotto VALUES(NULL,'',$this->id,'{$datiPrimoAttributo["nome"]} $valorePrimoAttributo, {$attributo["nome"]} $valore',{$arrayCosti[$i]},1)";
                            $this->db->eseguiQueryLettura($query);
                        }
                        $i++;
                    }
                }
            }   
        }
        
        /*
         * Crea le variazioni del prodotto con un solo attributo di cui riceve l'id in input
         */
        function creaVariazioni($idAttributo) {
            $datiAttributo = $this->db->leggiSingolaRiga("geecEc_attributiProdotto",$idAttributo);
            $arrayValori   = explode(",",$datiAttributo["valori"]);
            $arrayCosti    = explode(",",$datiAttributo["costi"]);
            
            $i = 0;
            foreach($arrayValori as $valore) {
                $query = "INSERT INTO geecEc_variazioniProdotto VALUES(NULL,'',$this->id,'{$datiAttributo["nome"]} $valore',{$arrayCosti[$i]},1)";
                $this->db->eseguiQueryLettura($query);
                $i++;
            }
        }
        
        function modificaVariazione($id,$codiceProdotto,$nome,$costo,$quantita) {
            $query = "UPDATE geecEc_variazioniProdotto SET codiceProdotto='$codiceProdotto', nome = '$nome', costo = '$costo', quantita = '$quantita' WHERE id = $id";
            $this->db->eseguiQueryLettura($query);
        }
        
        function stampaImmaginiProdotto() {
            $query = "SELECT * FROM geec_immagini WHERE tipoImmagine LIKE 'immagineProdotto' AND idContenuto=".$this->id." ORDER BY posizione ASC";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($immagine = $risultatoQuery->fetch_assoc()) {
                $posizionePrecedente = $immagine["posizione"]-1;
                $posizioneSuccessiva = $immagine["posizione"]+1;
            ?>
                <div id="immagineContenuto<?php echo $immagine["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded">
                    <div class="form-row">
                        <div class="col-xl-3 mb-2 mb-xl-0">
                            <div class="aspect-ratio-21-9">
                                <img src="../../../<?php echo $immagine["percorso"] ?>">
                            </div>
                        </div>
                        <div class="col-md-8 col-xl-5 align-self-center mb-2 mb-md-0">
                            <div class="input-group input-group-sm mr-3 align-self-center">
                                <input type="text" id="didascaliaImmagine<?php echo $immagine["id"] ?>" class="form-control " value="<?php echo $immagine["descrizione"] ?>" placeholder="Diascalia" aria-label="Didascalia" aria-describedby="didascalia">
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-primary" onclick="modificaDidascaliaImmagine('../../../',<?php echo $immagine["id"] ?>)">Salva</button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 col-xl-2 align-self-center">
                            <form>
                                <div class="input-group input-group-sm d-flex align-items-center">
                                    <small class="text-muted mr-2">Pos.</small>
                                    <input type="number" id="posizioneImmagineContenuto<?php echo $immagine["id"]; ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $immagine["posizione"] ?>">
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" onclick="modificaPosizioneImmagineProdottoDaInput('../../../',<?php echo $this->id; ?>,<?php echo $immagine["id"]; ?>)">Salva</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-xl-2 align-self-center text-right azioni">
                            <div class="btn-group" role="group" aria-label="Basic example">
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="modificaPosizioneImmagineProdotto('../../../',<?php echo $this->getId(); ?>,<?php echo $immagine["id"]; ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="modificaPosizioneImmagineProdotto('../../../',<?php echo $this->getId(); ?>,<?php echo $immagine["id"]; ?>,<?php echo $posizioneSuccessiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="rendiImmagineInEvidenza(<?php echo $this->getId(); ?>,'<?php echo $immagine["percorso"]; ?>');" data-original-title="Metti in evidenza"><i class="far fa-image"></i></button>
                                <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" onclick="eliminaOccorrenzaImmagine('../../../',<?php echo $immagine["id"]; ?>,'<?php echo $immagine["percorso"]; ?>')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        function stampaAttributi() {
            $query = "SELECT * FROM geecEc_attributiProdotto WHERE idProdotto = $this->id";
            $ris   = $this->db->eseguiQueryLettura($query);
            ?>
            <div class="table-responsive table-sm mr-3">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Valori</th>
                            <th>Costi €</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            while($attributo = $ris->fetch_assoc()) {
                                ?>
                                <tr id="attributoProdotto<?php echo $attributo["id"] ?>">
                                    <td>
                                        <input type="text" id="nomeAttributoDaModificare<?php echo $attributo["id"] ?>" class="form-control" value="<?php echo $attributo["nome"] ?>" placeholder="Nome" aria-label="Nome" aria-describedby="nome">
                                    </td>
                                    <td>
                                        <input type="text" id="valoriAttributoDaModificare<?php echo $attributo["id"] ?>" class="form-control" value="<?php echo $attributo["valori"] ?>" placeholder="Valori" aria-label="Valori" aria-describedby="valori">
                                    </td>
                                    <td>
                                        <input type="text" id="costiValoriAttributoDaModificare<?php echo $attributo["id"] ?>" class="form-control" value="<?php echo $attributo["costi"] ?>" placeholder="Costi" aria-label="Costi" aria-describedby="costi">
                                    </td>
                                    <td>
                                        <div class="btn-group azioni">
                                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="modificaPosizioneImmagineProdotto('../../../',<?php echo $this->getId(); ?>,<?php echo $immagine["id"]; ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="modificaPosizioneImmagineProdotto('../../../',<?php echo $this->getId(); ?>,<?php echo $immagine["id"]; ?>,<?php echo $posizioneSuccessiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                                            <a class="btn modifica" href="javascript:void" onclick="modificaAttributo(<?php echo $attributo["id"] ?>)" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Salva"><i class="fas fa-check-square"></i> </a>
                                            <a class="btn modifica" href="javascript:void" onclick="creaVariazioni(<?php echo $attributo["id"] ?>)" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Crea variazioni con questo attributo"><i class="far fa-plus-square"></i> </a>
                                            <a class="btn elimina" href="javascript:void" onclick="eliminaElemento(<?php echo $attributo["id"] ?>,'<?php echo $attributo["nome"] ?>')" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Elimina"><i class="far fa-trash-alt"></i> </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php
                            }
                        ?>
                    </tbody>
                </table>
                </div>
            <?php
        }
        
        function stampaVariazioni() {
            $query = "SELECT * FROM geecEc_variazioniProdotto WHERE idProdotto = $this->id";
            $ris   = $this->db->eseguiQueryLettura($query);
            ?>
            <div class="table-responsive table-sm mr-3">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Codice</th>
                            <th>Nome</th>
                            <th>Disponibilità</th>
                            <th>Costo €</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            while($variazione = $ris->fetch_assoc()) {
                                ?>
                                <tr id="variazioneProdotto<?php echo $variazione["id"] ?>">
                                    <td>
                                        <input type="text" id="codiceVariazioneDaModificare<?php echo $variazione["id"] ?>" class="form-control" value="<?php echo $variazione["codiceProdotto"] ?>" placeholder="Codice" aria-label="Codice" aria-describedby="codice">
                                    </td>
                                    <td>
                                        <input type="text" id="nomeVariazioneDaModificare<?php echo $variazione["id"] ?>" class="form-control" value="<?php echo $variazione["nome"] ?>" placeholder="Nome" aria-label="Nome" aria-describedby="nome">
                                    </td>
                                    <td>
                                        <input type="number" id="quantitaVariazioneDaModificare<?php echo $variazione["id"] ?>" class="form-control" value="<?php echo $variazione["quantita"] ?>" placeholder="Quantità" aria-label="Quantità" aria-describedby="quantità">
                                    </td>
                                    <td>
                                        <input type="number" step="0.01" id="costoVariazioneDaModificare<?php echo $variazione["id"] ?>" class="form-control" value="<?php echo $variazione["costo"] ?>" placeholder="Costo" aria-label="Costo" aria-describedby="costo">
                                    </td>
                                    <td>
                                        <div class="btn-group azioni">
                                            <a class="btn modifica" href="javascript:void" onclick="modificaVariazione(<?php echo $variazione["id"] ?>)" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Salva"><i class="fas fa-check-square"></i> </a>
                                            <a class="btn elimina" href="javascript:void" onclick="eliminaVariazione(<?php echo $variazione["id"] ?>,'<?php echo $variazione["nome"] ?>')" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Elimina"><i class="far fa-trash-alt"></i> </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php
                            }
                        ?>
                    </tbody>
                </table>
                </div>
            <?php
        }
        
        function cssGenerato() {
            $queryPosizione = "SELECT * FROM geecB_composizionePagine WHERE idPagina=$this->id AND tipoElemento LIKE 'prodotto' ORDER BY posizione ASC";
            $risComponenti  = $this->db->eseguiQueryLettura($queryPosizione);
            
            $cssGenerato = "";
            while($componente = $risComponenti->fetch_assoc()) {
                $cssGeneratoSezione = "";
                if($componente["margineSezione"]!="" || $componente["paddingSezione"]!="") {
                    $stringaMargine = ($componente["margineSezione"]!="") ? "margin:{$componente["margineSezione"]};" : "";
                    $stringaPadding = ($componente["paddingSezione"]!="") ? "padding:{$componente["paddingSezione"]};" : "";
                    $cssGeneratoSezione = "
                    #{$componente["idSezione"]} {
                        $stringaMargine
                        $stringaPadding
                    }
                    ";
                }
                $cssGenerato.= $cssGeneratoSezione;
            }
            return $cssGenerato;
        }
        
        function aggiornaCssGenerato() {
            $cssGenerato = $this->cssGenerato();
            
            $queryPosizioneElementoPrincipale = "UPDATE geecB_contenuti SET cssGenerato='$cssGenerato' WHERE id = $this->id ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function stampaComponentiProdotto($percorsoBase = "../../") {
            
            $datiGeecomCMS = $this->db->leggiSingolaRiga("geec_prodotti",1);
            $impostazioni  = recuperaImpostazioni($this->db);
            $tipoElemento  = "prodotto";
            $linkBaseAreaAmministrativaCMS = $impostazioni["urlSito"]."/".str_replace("../","",$datiGeecomCMS["percorso"]);
            
            $queryComponentiDaMostrare = "SELECT c.id, c.idSezione, c.idElemento, c.classeSezione, c.testo, cm.nome, cm.tipo, cm.icona, cm.paginaGestione, cm.tabellaRiferimento, c.posizione, c.margineSezione, c.paddingSezione, c.aTuttaLarghezza, c.coloreSfondo, c.immagineSfondo, c.videoSfondo FROM geecB_composizionePagine AS c JOIN geecB_componenti AS cm ON c.idComponente=cm.id WHERE c.idPagina = {$this->getId()} AND tipoElemento LIKE '$tipoElemento'  ORDER BY c.posizione ASC";
            $risComponenti = $this->db->eseguiQueryLettura($queryComponentiDaMostrare);

            // se nella pagina ci sono più di 7 componenti viene inserito anche un pulsante in 
            // alto per non costringere l'utente ad arrivare in fondo alla pagina
            if($risComponenti->num_rows>7) {
        ?>
                <button type="button" class="btn btn-success btn-block mb-3" data-toggle="modal" data-target="#aggiungi-componente"><i class="fas fa-plus"></i> Aggiungi un componente</button>
        <?php
            }
            if($risComponenti->num_rows==0) {
        ?>
                <div class="card bg-light text-center mb-3">
                    <div class="card-body">
                        Non ci sono componenti
                    </div>
                </div>
        <?php
            }
            else {

                while($componente = $risComponenti->fetch_assoc()) {
                    if($componente["tipo"]=="componenteDinamico" || $componente["tipo"]=="pagine") {
                        $nomeElemento = "";
                    }
                    else {
                        $elemento = $this->db->leggiSingolaRiga($componente["tabellaRiferimento"],$componente["idElemento"]);
                        $nomeElemento = filter_var($elemento["nome"],FILTER_SANITIZE_ADD_SLASHES);
                    }

                    if($componente["tipo"]!="componenteDinamico") {
                        $linkModificaComponente = creaLinkModifica($componente,$linkBaseAreaAmministrativaCMS);
                        $stringaPulsanteModifica = "onclick=\"{location.href='$linkModificaComponente';}\"";
                    }
                    else {
                        $stringaPulsanteModifica = "data-toggle=\"modal\" data-target=\"#configuraComponente{$componente["id"]}";
                    }

                    $posizionePrecedente = $componente["posizione"]-1;
                    $posizioneSuccessiva = $componente["posizione"]+1;
                    $nomeComponente      = filter_var($componente["nome"],FILTER_SANITIZE_ADD_SLASHES);
                    echo"<div id=\"componentePagina{$componente["id"]}\" class=\"card mb-3\">
                        <div class=\"card-header py-1 pr-sm-1 d-sm-flex justify-content-between align-items-center text-center\">
                            <div class=\"mb-1 mb-sm-0 d-flex align-items-center justify-content-start\">
                                <small class=\"text-muted mr-3\"><em><strong>ID:</strong></em> {$componente["idSezione"]} </small>
                                <small class=\"text-muted\"><em><strong>Classi:</strong></em> {$componente["classeSezione"]} </small>
                            </div>
                            <div class=\"azioni d-flex align-items-center justify-content-end\">
                                <form class=\"d-inline-flex mr-sm-1\">
                                    <div class=\"input-group input-group-sm d-flex align-items-center\">
                                        <small class=\"text-muted mr-2\">Pos.</small>
                                        <input type=\"number\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$componente["posizione"]}\" id=\"posizioneComponente{$componente["id"]}\">
                                        <div class=\"input-group-append\">
                                            <button class=\"btn btn-primary\" type=\"button\" onclick=\"modificaPosizioneComponenteDaInput({$componente["id"]})\">Salva</button>
                                        </div>
                                    </div>
                                </form>
                                <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta su\" onclick={modificaPosizioneComponente({$componente["id"]},$posizionePrecedente);}><i class=\"fas fa-arrow-up\" ></i></button>
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta giu\" onclick={modificaPosizioneComponente({$componente["id"]},$posizioneSuccessiva);}><i class=\"fas fa-arrow-down\"></i></button>
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Configura\" onclick=\"modificaImpostazioniSezione({$componente["id"]},'{$componente["idSezione"]}','{$componente["classeSezione"]}','{$componente["coloreSfondo"]}','{$componente["immagineSfondo"]}','{$componente["videoSfondo"]}')\"><i class=\"fas fa-cog\"></i></button>
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Duplica\" onclick=\"duplicaComponente({$componente["id"]})\"><i class=\"far fa-clone\"></i></button>
                                    <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaComponentePagina({$componente["id"]},'$percorsoBase{$componente["icona"]}','$nomeComponente','$nomeElemento')\" ><i class=\"far fa-trash-alt\"></i></button>
                                </div>
                           </div>
                        </div>";
                        
                        if($componente["nome"]=="Sezione a due colonne") {
                            $datiSezioneDoppia = $this->db->leggiSingolaRiga("geec_sezioniADueColonne",$componente["idElemento"]);
                            $classiDiv = explode(", ", $datiSezioneDoppia["proporzioni"]);
                        ?>
                        <div class= "card-body">
                            <div class="form-row align-items-center">
                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="inputPassword3" >Proporzioni</label>
                                    <select class="form-control" id="proporzioniSezione<?php echo $componente["idElemento"] ?>" onChange="aggiornaDivSezioneMultipla(<?php echo $componente["idElemento"] ?>)" >
                                    <?php 
                                        $arrayProporzioni = array("col-md-6, col-md-6"=>"1/2 - 1/2",
                                            "col-md-4, col-md-8"=>"1/3 - 2/3",
                                            "col-md-3, col-md-9"=>"1/4 - 3/4",
                                            "col-md-2, col-md-10"=>"1/6 - 5/6",
                                            "col-md-8, col-md-4"=>  "2/3 - 1/3",
                                            "col-md-9, col-md-3"=>  "3/4 - 1/4",
                                            "col-md-10, col-md-2"=>  "5/6 - 1/6"
                                        );
                                        foreach($arrayProporzioni as $classe=>$descrizione) {
                                            if($datiSezioneDoppia["proporzioni"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>

                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="">Allineamento <span class="d-none d-sm-inline-block">contenuti</span></label>
                                    <select class="form-control" id="allineamentoSezione<?php echo $componente["idElemento"] ?>">
                                        <?php 
                                        $arrayAllineamenti = array("d-flex align-items-start"=>"In alto",
                                            "d-flex align-items-center"=>"Al centro",
                                            "d-flex align-items-end"=>"In basso",
                                            "d-flex align-items-baseline"=>"Linea base",
                                            "d-flex align-items-stretch"=>  "Stretch"
                                        );
                                        foreach($arrayAllineamenti as $classe=>$descrizione) {
                                            if($datiSezioneDoppia["allineamento"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>
                                <div class="col">
                                    <button type="button" onclick="salvaDatiSezioneMultipla(<?php echo $componente["idElemento"] ?>,'geec_sezioniADueColonne')" class="btn btn-primary float-right float-md-left">Salva<i class="fas fa-check fa-fw ml-1"></i></button>
                                </div>
                            </div>
                            <hr>

                            <div class="form-row">
                                <div id="div1SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[0] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneDoppia,1,$linkBaseAreaAmministrativaCMS,'geec_sezioniADueColonne'); ?>
                                </div>
                                <div id="div2SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[1] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneDoppia,2,$linkBaseAreaAmministrativaCMS,'geec_sezioniADueColonne'); ?>
                                </div>
                            </div>
                        </div>
                    <?php
                        }
                        else if($componente["nome"]=="Sezione a tre colonne") {
                            $datiSezioneTripla = $this->db->leggiSingolaRiga("geec_sezioniATreColonne",$componente["idElemento"]);
                            $classiDiv = explode(", ", $datiSezioneTripla["proporzioni"]);
                        ?>
                        <div class= "card-body">
                            <div class="form-row align-items-center">
                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="inputPassword3" >Proporzioni</label>
                                    <select class="form-control" id="proporzioniSezione<?php echo $componente["idElemento"] ?>" onChange="aggiornaDivSezioneMultipla(<?php echo $componente["idElemento"] ?>)" >
                                    <?php 
                                        $arrayProporzioni = array("col-md-4, col-md-4, col-md-4"=>"1/3 - 1/3 - 1/3",
                                            "col-md-6, col-md-3, col-md-3"=>"1/2 - 1/4 - 1/4",
                                            "col-md-3, col-md-6, col-md-3"=>"1/4 - 1/2 - 1/4",
                                            "col-md-3, col-md-3, col-md-6"=>"1/4 - 1/4 - 1/2"
                                        );
                                        foreach($arrayProporzioni as $classe=>$descrizione) {
                                            if($datiSezioneTripla["proporzioni"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>

                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="">Allineamento <span class="d-none d-sm-inline-block">contenuti</span></label>
                                    <select class="form-control" id="allineamentoSezione<?php echo $componente["idElemento"] ?>">
                                        <?php 
                                        $arrayAllineamenti = array("d-flex align-items-start"=>"In alto",
                                            "d-flex align-items-center"=>"Al centro",
                                            "d-flex align-items-end"=>"In basso",
                                            "d-flex align-items-baseline"=>"Linea base",
                                            "d-flex align-items-stretch"=>  "Stretch"
                                        );
                                        foreach($arrayAllineamenti as $classe=>$descrizione) {
                                            if($datiSezioneTripla["allineamento"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>
                                <div class="col">
                                    <button type="button" onclick="salvaDatiSezioneMultipla(<?php echo $componente["idElemento"] ?>,'geec_sezioniATreColonne')" class="btn btn-primary float-right float-md-left">Salva<i class="fas fa-check fa-fw ml-1"></i></button>
                                </div>
                            </div>
                            <hr>

                            <div class="form-row">
                                <div id="div1SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[0] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneTripla,1,$linkBaseAreaAmministrativaCMS,'geec_sezioniATreColonne'); ?>
                                </div>
                                <div id="div2SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[1] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneTripla,2,$linkBaseAreaAmministrativaCMS,'geec_sezioniATreColonne'); ?>
                                </div>
                                <div id="div3SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[2] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneTripla,3,$linkBaseAreaAmministrativaCMS,'geec_sezioniATreColonne'); ?>
                                </div>
                            </div>
                        </div>
                    <?php            
                        }
                        else if($componente["nome"]=="Sezione a quattro colonne") {
                            $datiSezioneQuadrupla = $this->db->leggiSingolaRiga("geec_sezioniAQuattroColonne",$componente["idElemento"]);
                        ?>
                        <div class= "card-body">
                            <div class="form-row align-items-center">                                
                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="">Allineamento <span class="d-none d-sm-inline-block">contenuti</span></label>
                                    <select class="form-control" id="allineamentoSezione<?php echo $componente["idElemento"] ?>">
                                        <?php 
                                        $arrayAllineamenti = array("d-flex align-items-start"=>"In alto",
                                            "d-flex align-items-center"=>"Al centro",
                                            "d-flex align-items-end"=>"In basso",
                                            "d-flex align-items-baseline"=>"Linea base",
                                            "d-flex align-items-stretch"=>  "Stretch"
                                        );
                                        foreach($arrayAllineamenti as $classe=>$descrizione) {
                                            if($datiSezioneQuadrupla["allineamento"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>
                                <div class="col">
                                    <button type="button" onclick="salvaDatiSezioneMultipla(<?php echo $componente["idElemento"] ?>,'geec_sezioniAQuattroColonne')" class="btn btn-primary float-right float-md-left">Salva<i class="fas fa-check fa-fw ml-1"></i></button>
                                </div>
                            </div>
                            <hr>

                            <div class="form-row">
                                <div id="div1SezioneMultipla<?php echo $componente["idElemento"] ?>" class="col-md-3 d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneQuadrupla,1,$linkBaseAreaAmministrativaCMS,'geec_sezioniAQuattroColonne'); ?>
                                </div>
                                <div id="div2SezioneMultipla<?php echo $componente["idElemento"] ?>" class="col-md-3 d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneQuadrupla,2,$linkBaseAreaAmministrativaCMS,'geec_sezioniAQuattroColonne'); ?>
                                </div>
                                <div id="div3SezioneMultipla<?php echo $componente["idElemento"] ?>" class="col-md-3 d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneQuadrupla,3,$linkBaseAreaAmministrativaCMS,'geec_sezioniAQuattroColonne'); ?>
                                </div>
                                <div id="div4SezioneMultipla<?php echo $componente["idElemento"] ?>" class="col-md-3 d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneQuadrupla,4,$linkBaseAreaAmministrativaCMS,'geec_sezioniAQuattroColonne'); ?>
                                </div>
                            </div>
                        </div>
                    <?php            
                        }
                        else {
                            echo"<div class= \"card-body py-lg-0 d-flex align-items-center\">
                                <img class=\"thumb d-none d-lg-block\" src=\"$percorsoBase{$componente["icona"]}\">
                                <span class=\"mr-3 align-self-center text-primary\"><em>{$componente["nome"]}</em></span>
                                <div class=\"input-group mr-3\">";
                                    if($componente["tipo"]=="componenteDinamicoPagine") {
                                        $queryElementiComponente = "SELECT * FROM {$componente["tabellaRiferimento"]}";
                                        $risElementoComponente   = $this->db->eseguiQueryLettura($queryElementiComponente);
                                        echo"<select class=\"form-control form-control-sm\" id=\"idElementoComponente{$componente["id"]}\">";
                                                while($elemento = $risElementoComponente->fetch_assoc()) {
                                                    if($componente["idElemento"]==$elemento["id"]) {
                                                        echo"<option value=\"{$elemento["id"]}\" selected >{$elemento["nome"]}</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"{$elemento["id"]}\">{$elemento["nome"]}</option>";
                                                    }
                                                }
                                        echo"</select>
                                        <div class=\"input-group-append\">
                                            <button type=\"button\" class=\"btn btn-primary btn-sm\" onclick=\"cambiaIdElemento({$componente["id"]})\">Salva</button>
                                        </div>";
                                    }
                                    else {
                                        echo"<span class=\"text-truncate text-muted d-block w-75\">". substr(strip_tags($componente["testo"]),0,90)."</span>";
                                    }
                                    echo"
                                </div>
                                <div class=\"btn-group\">
                                    <button type=\"button\" class=\"btn btn-primary btn-sm text-nowrap\" $stringaPulsanteModifica \"><span class=\"d-none d-lg-inline-block\">Configura</span><i class=\"far fa-edit fa-fw ml-1\"></i></button>
                                </div>
                            </div>";
                        }
                    echo"</div>";
                }
            }
        }
        
        /*
         * Metodo che consente di stampare il box delle traduzioni che compare nella pagina creaContenuto.php
         * 
         * ha bisogno di recuperare la variabile globale contenente le lingue
         */
        function stampaBoxTraduzioni() {
                $lingue = $GLOBALS["lingue"];
                if($this->getProdottoRiferimento()==0) {
                    $queryTraduzioni = "SELECT * FROM geecEc_prodotti WHERE prodottoRiferimento={$this->getId()} ";
                }
                else {
                    $queryTraduzioni = "SELECT * FROM geecEc_prodotti WHERE id={$this->getProdottoRiferimento()} OR (prodottoRiferimento={$this->getProdottoRiferimento()} AND id!={$this->getId()})";
                }

                $result = $this->db->eseguiQueryLettura($queryTraduzioni);
                if($result->num_rows>0) {
                    echo"<hr>
                    <p>Traduzioni associate:</p>";                                            
                }

                while($traduzione=$result->fetch_assoc()) {
                    unset($lingue[array_search($traduzione["lingua"], $lingue)]);
            ?>
                    <div class="d-flex justify-content-between align-items-center mb-2" id="pagina<?php echo $traduzione["id"] ?>">
                        <div>
                            <button type="button" onclick="eliminaPagina(<?php echo $traduzione["id"] ?>,'<?php echo $traduzione["nome"] ?>')" class="btn btn-light btn-sm mr-1 text-secondary" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                            <a href="creaProdotto.php?id=<?php echo $traduzione["id"] ?>"><?php echo $traduzione["nome"] ?></a>
                        </div>
                        <img src="../../../<?php echo percorsoImmagineBandiera($traduzione["lingua"]) ?>" alt="<?php echo $traduzione["lingua"] ?>">
                    </div>
            <?php
                }
            ?>
            <hr>
            <div class="input-group">
                <select class="form-control" id="linguaTraduzione">
                    <option value="">Crea una traduzione...</option>
                    <?php
                        // elimina la lingua del contenuto
                        unset($lingue[array_search($this->getLingua(), $lingue)]);
                        foreach($lingue as $lingua) {
                            echo"<option value=\"$lingua\" >$lingua </option>";
                        }
                    ?>
                </select>
                <div class="input-group-append">
                    <button class="btn btn-primary" type="button" onclick="traduci(<?php echo(($this->getProdottoRiferimento()==0) ? $this->getId() : $this->getProdottoRiferimento()) ?>)">Crea</button>
                </div>
            </div>
            <?php
        }
        
        function invertiStato() {
            if($this->pubblicato=="si") {
                $statoAggiornato = "no";
            }
            else {
                $statoAggiornato = "si";
            }
            
            $queryModifica   = "UPDATE geecEc_prodotti SET pubblicato='$statoAggiornato' WHERE id=$this->id";                
            $this->db->eseguiQueryLettura($queryModifica);
            return $statoAggiornato;
        }
        
        /*
         * Getter & setter
         */
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getCodiceProdotto() {
            return $this->codiceProdotto;
        }

        public function getIdFornitore() {
            return $this->idFornitore;
        }

        public function getLingua() {
            return $this->lingua;
        }

        public function getProdottoRiferimento() {
            return $this->prodottoRiferimento;
        }

        public function getProdottoPadre() {
            return $this->prodottoPadre;
        }

        public function getEan() {
            return $this->ean;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getAlias() {
            return $this->alias;
        }

        public function getImmagineInEvidenza() {
            return $this->immagine;
        }

        public function getTemplate() {
            return $this->template;
        }

        public function getPubblicato() {
            return $this->pubblicato;
        }

        public function getUsaVariazioni() {
            return $this->usaVariazioni;
        }

        public function getCategoria() {
            return $this->categoria;
        }

        public function getProdottoInesauribile() {
            return $this->prodottoInesauribile;
        }
        
        public function getDisponibilita() {
            return $this->disponibilita;
        }

        
        public function getPrezzo() {
            return $this->prezzo;
        }

        public function getPrezzoOfferta() {
            return $this->prezzoOfferta;
        }

        public function getIva() {
            return $this->iva;
        }
        
        public function getPrezzoAcquisto() {
            return $this->prezzoAcquisto;
        }

        public function getPrezzoUnitario() {
            return $this->prezzoUnitario;
        }

        public function getUnita() {
            return $this->unita;
        }

        public function getMinimoAcquisto() {
            return $this->minimoAcquisto;
        }

        public function getMetaDescrizione() {
            return $this->metaDescrizione;
        }

        public function getDescrizione() {
            return $this->descrizione;
        }

        public function getTestoDettagli() {
            return $this->testoDettagli;
        }

        public function getMarca() {
            return $this->marca;
        }

        public function getModello() {
            return $this->modello;
        }

        public function getFormato() {
            return $this->formato;
        }

        public function getMateriale() {
            return $this->materiale;
        }

        public function getCapacità() {
            return $this->capacita;
        }

        public function getColore() {
            return $this->colore;
        }

        public function getLarghezza() {
            return $this->larghezza;
        }

        public function getAltezza() {
            return $this->altezza;
        }

        public function getProfondita() {
            return $this->profondita;
        }

        public function getPeso() {
            return $this->peso;
        }

        public function getPesoVolumetrico() {
            return $this->pesoVolumetrico;
        }

        public function getTipoProdotto() {
            return $this->tipoProdotto;
        }

        public function getNumeroVisite() {
            return $this->numeroVisite;
        }

        public function getNumeroVendite() {
            return $this->numeroVendite;
        }
        
        public function getAbilitaCommenti() {
            return $this->abilitaCommenti;
        }

        public function getDataInserimento() {
            return $this->dataInserimento;
        }

        public function getDatiProdotto() {
            return $this->datiProdotto;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setCodiceProdotto($codiceProdotto): void {
            $this->codiceProdotto = $codiceProdotto;
        }

        public function setIdFornitore($idFornitore): void {
            $this->idFornitore = $idFornitore;
        }

        public function setLingua($lingua): void {
            $this->lingua = $lingua;
        }

        public function setProdottoRiferimento($prodottoRiferimento): void {
            $this->prodottoRiferimento = $prodottoRiferimento;
        }

        public function setProdottoPadre($prodottoPadre): void {
            $this->prodottoPadre = $prodottoPadre;
        }

        public function setEan($ean): void {
            $this->ean = $ean;
        }

        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setAlias($alias): void {
            $this->alias = $alias;
        }

        public function setImmagineInEvidenza($immagine): void {
            $this->immagine = $immagine;
        }

        public function setTemplate($template): void {
            $this->template = $template;
        }

        public function setPubblicato($pubblicato): void {
            $this->pubblicato = $pubblicato;
        }

        public function setUsaVariazioni($usaVariazioni): void {
            $this->usaVariazioni = $usaVariazioni;
        }

        public function setCategoria($categoria): void {
            $this->categoria = $categoria;
        }

        public function setDisponibilita($disponibilita): void {
            $this->disponibilita = $disponibilita;
        }
        
        public function setProdottoInesauribile($prodottoInesauribile): void {
            $this->prodottoInesauribile = $prodottoInesauribile;
        }
        
        public function setPrezzo($prezzo): void {
            $this->prezzo = $prezzo;
        }

        public function setIva($iva): void {
            $this->iva = $iva;
        }
        
        public function setPrezzoOfferta($prezzoOfferta): void {
            $this->prezzoOfferta = $prezzoOfferta;
        }

        public function setPrezzoAcquisto($prezzoAcquisto): void {
            $this->prezzoAcquisto = $prezzoAcquisto;
        }

        public function setPrezzoUnitario($prezzoUnitario): void {
            $this->prezzoUnitario = $prezzoUnitario;
        }

        public function setUnita($unita): void {
            $this->unita = $unita;
        }

        public function setMinimoAcquisto($minimoAcquisto): void {
            $this->minimoAcquisto = $minimoAcquisto;
        }

        public function setMetaDescrizione($metaDescrizione): void {
            $this->metaDescrizione = $metaDescrizione;
        }

        public function setDescrizione($descrizione): void {
            $this->descrizione = $descrizione;
        }

        public function setTestoDettagli($testoDettagli): void {
            $this->testoDettagli = $testoDettagli;
        }

        public function setMarca($marca): void {
            $this->marca = $marca;
        }

        public function setModello($modello): void {
            $this->modello = $modello;
        }

        public function setFormato($formato): void {
            $this->formato = $formato;
        }

        public function setMateriale($materiale): void {
            $this->materiale = $materiale;
        }

        public function setCapacità($capacità): void {
            $this->capacita = $capacità;
        }

        public function setColore($colore): void {
            $this->colore = $colore;
        }

        public function setLarghezza($larghezza): void {
            $this->larghezza = $larghezza;
        }

        public function setAltezza($altezza): void {
            $this->altezza = $altezza;
        }

        public function setProfondita($profondita): void {
            $this->profondita = $profondita;
        }

        public function setPeso($peso): void {
            $this->peso = $peso;
        }

        public function setPesoVolumetrico($pesoVolumetrico): void {
            $this->pesoVolumetrico = $pesoVolumetrico;
        }

        public function setTipoProdotto($tipoProdotto): void {
            $this->tipoProdotto = $tipoProdotto;
        }

        public function setNumeroVisite($numeroVisite): void {
            $this->numeroVisite = $numeroVisite;
        }

        public function setNumeroVendite($numeroVendite): void {
            $this->numeroVendite = $numeroVendite;
        }
        
        public function setAbilitaCommenti($abilitaCommenti): void {
            $this->abilitaCommenti = $abilitaCommenti;
        }

        public function setDataInserimento($dataInserimento): void {
            $this->dataInserimento = $dataInserimento;
        }

        public function setDatiProdotto($datiProdotto): void {
            $this->datiProdotto = $datiProdotto;
        }

    }
